;*******************************************************************************
;				Information					
;*******************************************************************************
;AutoHotkey Version: 	1.0.47.06						
;Language: 		English							
;Platform: 		XP/Vista						
;Author: 		Fluffy654 <rupert654@gmail.com>				
;Script Function:	Adds the functionality of Windows 7 hotkeys XP/Vista	
;*******************************************************************************
;				Version History					
;*******************************************************************************
;0.4
;*Win+Left/Right/Up now cycle through different window arrangements									
;*Fixed a bug where Windows would remain transparent after releasing Win+Space
;*Fixed a bug where Windows would remain transparent if a key was pressed	
;*Preferences were completely broken but are now fixed				
;*Misc UI enhancements							
;0.3										
;*Transparency is now fully supported and makes all windows transparent		
;*Win+Home is now functional and minimizes all but the active window		
;0.2										
;*Fixed a bug where the user could dock and minimize the desktop		
;*Fixed a bug where windows would minimize instead of restoring			
;*Hotkeys are now customisable via the preferences option in the tray menu	
;0.1										
;*Added Maximize (Win+Up), Minimize (Win+Down), Dock hotkeys (Win+Left/Right)	
;*Added partial support for Transparency (Win+Space)				
;*******************************************************************************
;				Settings					
;*******************************************************************************
#NoEnv  									
SendMode Input  								
SetWorkingDir %A_ScriptDir%  							
;*******************************************************************************
;				Variables					
;*******************************************************************************
SysGet, Monitor, MonitorWorkArea						
WS_EX_APPWINDOW = 0x40000							
WS_EX_TOOLWINDOW = 0x80								
GW_OWNER = 4									
Left := 0
;*******************************************************************************
;				Load Preferences				
;*******************************************************************************
IniRead, Maximize, Windows7.ini, Win7Hotkeys, Maximize				
IniRead, Minimize, Windows7.ini, Win7Hotkeys, Minimize				
IniRead, DockLeft, Windows7.ini, Win7Hotkeys, DockLeft				
IniRead, DockRight, Windows7.ini, Win7Hotkeys, DockRight			
IniRead, Transparent, Windows7.ini, Win7Hotkeys, Transparent					
IniRead, MinimizeOther, Windows7.ini, Win7Hotkeys, MinimizeOther		
;*******************************************************************************
;				Hotkeys						
;*******************************************************************************
Hotkey, %Maximize%, Maximize							
Hotkey, %Minimize%, Minimize							
Hotkey, %DockLeft%, DockLeft							
Hotkey, %DockRight%, DockRight							
Hotkey, %Transparent%, Transparent						
Hotkey, %MinimizeOther%, MinimizeOther						
;*******************************************************************************
;				GUI						
;*******************************************************************************
Menu, tray, NoStandard
Menu, tray, add, Preferences, Preferences
Menu, tray, add, Reload, Reload
Menu, tray, add, Exit, Exit
Menu, tray, Default, Preferences
Menu, tray, Icon, icon.ico,, 1
Menu, tray, Tip, Windows 7 Shortcuts 0.4				
Gui, Add, Text, x10 y10 w100, Maximize						
Gui, Add, Text, yp+25 w100, Minimize/Restore				
Gui, Add, Text, yp+25 w100, Dock Left					
Gui, Add, Text, yp+25 w100, Dock Right					
Gui, Add, Text, yp+25 w100, Transparent					
Gui, Add, Text, yp+25 w100, Minimize All Other				
Gui, Add, Button, yp+25 w100 Default gSave, Save
Gui, Add, Text, yp+30 w200 cRed, Warning! Hotkeys will stop working if invalid key names are entered				
Gui, Add, Text, yp+30 w200 cBlue gHelp, Click here for a list of key names	
Gui, Add, Edit, x110 y10 w100 vMaximize, %Maximize%				
Gui, Add, Edit, yp+25 w100 vMinimize, %Minimize%				
Gui, Add, Edit, yp+25 w100 vDockLeft, %DockLeft%				
Gui, Add, Edit, yp+25 w100 vDockRight, %DockRight%				
Gui, Add, Edit, yp+25 w100 vTransparent, %Transparent%			
Gui, Add, Edit, yp+25 w100 vMinimizeOther, %MinimizeOther%			
Gui, Add, Button, yp+25 w100 gCancel, Cancel				
return										
;*******************************************************************************
;				Hotkey Labels					
;*******************************************************************************
Maximize: 
WinGetActiveStats, Title, W, H, X, Y
WinGet MX, MinMax, A
IfEqual, Title, Progman, Return
If MX	
{							
	WinRestore, A
	WinMove, A,, 0, 0, % MonitorRight, % MonitorBottom/2
}
else if (W = MonitorRight and H = MonitorBottom/2 and X = 0 and Y = 0)
	WinMove, A,,, % MonitorBottom/2
Else	WinMaximize, A									
return										
										
Minimize:
WinGetActiveStats, Title, W, H, X, Y									
WinGet MX, MinMax, A
IfEqual, Title, Progman, Return								
If MX										
	WinRestore, A								
Else 	WinMinimize, A								
return 										
										
DockLeft:									
WinGetActiveStats, Title, W, H, X, Y						
WinGet MX, MinMax, A
IfEqual, Title, Progman, Return
if MX
	WinRestore, A																	
if (W = MonitorRight/2 and H = MonitorBottom and X = 0 and Y = 0)
	WinMove, A,,,,, % MonitorBottom/2
else if (W = MonitorRight/2 and H = MonitorBottom/2 and X = 0 and Y = 0)
	WinMove, A,,, % MonitorBottom/2
else 	WinMove, A,, 0, 0, % MonitorRight/2, %MonitorBottom%
return			 							
										
DockRight:									
WinGetActiveStats, Title, W, H, X, Y						
WinGet MX, MinMax, A								
if MX
	WinRestore, A								
IfEqual, Title, Progman, Return			
if (W = MonitorRight/2 and H = MonitorBottom and X = MonitorRight/2 and Y = 0)
	WinMove, A,,,,, % MonitorBottom/2
else if (W = MonitorRight/2 and H = MonitorBottom/2 and X = MonitorRight/2 and Y = 0)
	WinMove, A,,, % MonitorBottom/2
else	WinMove, A,, % MonitorRight/2, 0, % MonitorRight/2, %MonitorBottom%	
return										
										
Transparent:									
WinGet, list, List								
loop, %list%	
{
	wid := list%A_Index%							
	WinGet, es, ExStyle, ahk_id %wid%					
	if ((!DllCall("GetWindow", "uint", wid, "uint", GW_OWNER) 		
	and !(es & WS_EX_TOOLWINDOW))						
	or (es & WS_EX_APPWINDOW))
		;DllCall("AnimateWindow","UInt", wid,"Int",500,"UInt","0x20000")						
		WinSet, Transparent, 10, ahk_id %wid%				
}
Loop
{
	L := GetKeyState("LWin")
	R := GetKeyState("RWin")
If (L = R)
	Break
}
loop, %list%
{	
	wid := list%A_Index%							
	WinGet, es, ExStyle, ahk_id %wid%					
	if ((!DllCall("GetWindow", "uint", wid, "uint", GW_OWNER) 		
	and !(es & WS_EX_TOOLWINDOW))						
	or (es & WS_EX_APPWINDOW))
		;DllCall("AnimateWindow","UInt", wid ,"Int",500,"UInt","0xa0000")				
		WinSet, Transparent, 255, ahk_id %wid%
}								
return										
										
MinimizeOther:									
ActiveId := WinActive("A")							
WinGet, list, List								
loop, %list%									
{										
	wid := list%A_Index%							
	WinGet, es, ExStyle, ahk_id %wid%					
	if ((!DllCall("GetWindow", "uint", wid, "uint", GW_OWNER) 		
	and !(es & WS_EX_TOOLWINDOW))						
	or (es & WS_EX_APPWINDOW)) 						
	and ActiveId != wid							
		WinMinimize, ahk_id %wid%					
}										
return										
;*******************************************************************************
;				GUI Hotkeys					
;*******************************************************************************
Preferences:									
Gui, Show									
return										
										
Save:										
Gui, Submit									
IniWrite, %Maximize%, Windows7.ini, Win7Hotkeys, Maximize			
IniWrite, %Minimize%, Windows7.ini, Win7Hotkeys, Minimize			
IniWrite, %DockLeft%, Windows7.ini, Win7Hotkeys, DockLeft			
IniWrite, %DockRight%, Windows7.ini, Win7Hotkeys, DockRight			
IniWrite, %Transparent%, Windows7.ini, Win7Hotkeys, Transparent	
IniWrite, %MinimizeOther%, Windows7.ini, Win7Hotkeys, MinimizeOther			
Reload										
										
Cancel:										
Gui, Cancel									
return										
										
Help:										
Run, http://www.autohotkey.com/docs/KeyList.htm					
return	

Reload:
Reload
return

Exit:
ExitApp									